/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package me.zhengjie.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import me.zhengjie.service.XxgxsqsqService;
import me.zhengjie.service.XxsysqlbService;
import me.zhengjie.service.dto.XxgxsqsqDeployQueryCriteria;
import me.zhengjie.service.dto.XxsysqlbDeployQueryCriteria;
import me.zhengjie.util.R;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;


/**
 * @author Jing Xiduo
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("api/XxsysqlbController")
@Api(tags = "查询：信息使用授权列表接口流水")
public class XxsysqlbController {

    @Autowired
    private XxsysqlbService xxsysqlbService;

    @ApiOperation(value = "查询信息使用授权列表接口流水")
    @GetMapping
    @PreAuthorize("@el.check('serverDeploy:list')")
    public ResponseEntity<Object> query(XxsysqlbDeployQueryCriteria criteria, Pageable pageable){
        return new ResponseEntity<>(xxsysqlbService.queryAll(criteria,pageable),HttpStatus.OK);
    }

    @ApiOperation("查询信息使用授权列表返回明细")
    @RequestMapping("/QueryXxsysqlbFhmx")
    public R QueryXxsysqlbFhmx(@RequestParam("id") String id) {
        List<Map> visits = xxsysqlbService.QueryXxsysqlbFhmx(id);
        return new R<>(visits);
    }
}
