package me.zhengjie.serviceimpl;

import lombok.RequiredArgsConstructor;
import me.zhengjie.MybatisMapper.DkbscxMybatisMapper;
import me.zhengjie.MybatisMapper.DkzlcxMybatisMapper;
import me.zhengjie.domain.DkbscxDeploy;
import me.zhengjie.domain.DkzlcxDeploy;
import me.zhengjie.mapper.DkbscxMapper;
import me.zhengjie.mapper.DkzlcxMapper;
import me.zhengjie.repository.DkbscxDeployRepository;
import me.zhengjie.repository.DkzlcxDeployRepository;
import me.zhengjie.service.DkbscxService;
import me.zhengjie.service.DkzlcxService;
import me.zhengjie.service.dto.DkbscxDeployQueryCriteria;
import me.zhengjie.service.dto.DkzlcxDeployQueryCriteria;
import me.zhengjie.utils.PageUtil;
import me.zhengjie.utils.QueryHelp;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @author Jing Xiduo
 * @date 2021-10-18
 */
@Service
@RequiredArgsConstructor
public class DkbscxServiceImpl implements DkbscxService {

    private final DkbscxDeployRepository dkbscxDeployRepository;
    private final DkbscxMapper dkbscxMapper;
    private final DkbscxMybatisMapper dkbscxMybatisMapper;
    @Override
    public Object queryAll(DkbscxDeployQueryCriteria criteria, Pageable pageable){
        Page<DkbscxDeploy> page = dkbscxDeployRepository.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,criteria,criteriaBuilder),pageable);
        return PageUtil.toPage(page.map(dkbscxMapper::toDto));
    }

    @Override
    public List<Map> QueryDkbscxFhmx(String id) {
        return dkbscxMybatisMapper.QueryDkbscxFhmx(id);
    }

}
