package me.zhengjie.controller;

import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import me.zhengjie.annotation.AnonymousAccess;
import me.zhengjie.service.IndexService;
import me.zhengjie.util.R;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author JiangHeJia
 * @version V1.0
 * @Title: IndexController
 * @Package el-admin
 * @Description: TODO(首页展示信息查询控制器)
 * @date 2021/10/12 21:28
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("api/IndexController")
@Api(tags = "查询：首页展示信息查询控制器")
public class IndexController {

    @Autowired
    private IndexService indexService;

    @AnonymousAccess
    @RequestMapping("/selectDemo")
    public R selectDemo() {
        return new R<>(indexService.selectDemo());
    }

}
