package me.zhengjie.serviceimpl;

import lombok.RequiredArgsConstructor;
import me.zhengjie.domain.DkzlcxDeploy;
import me.zhengjie.domain.LxjcjyDeploy;
import me.zhengjie.mapper.DkzlcxMapper;
import me.zhengjie.mapper.LxjcjyMapper;
import me.zhengjie.repository.DkzlcxDeployRepository;
import me.zhengjie.repository.LxjcjyDeployRepository;
import me.zhengjie.service.DkzlcxService;
import me.zhengjie.service.LxjcjyService;
import me.zhengjie.service.dto.DkzlcxDeployQueryCriteria;
import me.zhengjie.service.dto.LxjcjyDeployQueryCriteria;
import me.zhengjie.utils.PageUtil;
import me.zhengjie.utils.QueryHelp;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * @author Jing Xiduo
 * @date 2021-10-18
 */
@Service
@RequiredArgsConstructor
public class DkzlcxServiceImpl implements DkzlcxService {

    private final DkzlcxDeployRepository dkzlcxDeployRepository;
    private final DkzlcxMapper dkzlcxMapper;
    @Override
    public Object queryAll(DkzlcxDeployQueryCriteria criteria, Pageable pageable){
        Page<DkzlcxDeploy> page = dkzlcxDeployRepository.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,criteria,criteriaBuilder),pageable);
        return PageUtil.toPage(page.map(dkzlcxMapper::toDto));
    }

}
