package com.flowable.process;

import lombok.extern.slf4j.Slf4j;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.ProcessEngines;
import org.junit.Test;

@Slf4j
public class ProcessEngineTest {
    /**
     * 最简单的创建流程引擎的方法
     */
    @Test
    public void createProcessEngine(){
        ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
        assert (processEngine != null);
    }

    /**
     * 可以不通过xml配置流程引擎
     */
    @Test
    public void createProcesEngineNoXml(){
        ProcessEngine processEngine = ProcessEngineConfiguration.createStandaloneInMemProcessEngineConfiguration()
                .setDatabaseSchemaUpdate(ProcessEngineConfiguration.DB_SCHEMA_UPDATE_DROP_CREATE)
                .setJdbcUrl("jdbc:h2:mem:flowable;DB_CLOSE_DELAY=1000")
                .setAsyncExecutorActivate(false)
                .buildProcessEngine();
        assert (processEngine != null);
    }
}
