package me.zhengjie.serviceimpl;

import com.alibaba.fastjson.JSONObject;
import lombok.RequiredArgsConstructor;
import lombok.extern.java.Log;
import me.zhengjie.service.ICEGNService;
import me.zhengjie.util.shengneiUtil;
import me.zhengjie.util.JSONUtil;
import me.zhengjie.utils.RedisUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

/**
 * @author JiangHeJia
 * @version V1.0
 * @Title: IGatewayZsjJIServiceImpl
 * @Package el-admin
 * @Description: TODO(调用政务外网接口实现类)
 * @date 2021/10/11 11:14
 */
@Service
@Log
public class IGatewayZsjJIServiceImpl implements ICEGNService {

    @Autowired
    RedisUtils redisUtils;

    /**
     * @Title: queryEBaseinfos
     * @Description: TODO(企业登记信息查询实现)
     * * @param: Map
     * * @return: String
     * @date: 2021/10/11 13:56
     */
    @Override
    public String queryEBaseinfos(Map map1) {
        log.info("企业登记信息查询");
        CloseableHttpClient httpClinet = shengneiUtil.createSSLClientDefault();
        Map map = (Map) map1.get("BODY");
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String da = sdf.format(date);
        String url = "https://gateway.zsj.jl.cegn.cn/api/visual/queryEBaseinfos";
        JSONObject obj = new JSONObject();
        obj.put("appId", "9eb8158ca2654c149ed2e7ea6e5b6830");
        obj.put("version", "1.0.0");
        obj.put("charset", "2");
        obj.put("format", "JSON");
        obj.put("timestamp", da);
        obj.put("uniscid", map.get("TYSHXYDM"));
        obj.put("entName", map.get("DWMC"));
        log.info("发送内容" + obj);
        String doPost = shengneiUtil.doPost(url, obj.toString(), redisUtils.get("access_token").toString(), httpClinet);
        Map resultMap = JSONUtil.toMap(doPost);
        //todo-sn 2021/10/11 10:30 Ash:判断token是否失效，失效重新获取token后再次发送请求;未测试
        if ("token失效？".equals(resultMap.get("message"))){
            shengneiUtil.getToken(httpClinet);
            doPost = shengneiUtil.doPost(url, obj.toString(), redisUtils.get("access_token").toString(), httpClinet);
        }
        log.info("接口返回信息" + doPost);
        return doPost;
    }
}
