/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package me.zhengjie.controller;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import me.zhengjie.annotation.AnonymousAccess;
import me.zhengjie.service.JczlcxService;
import me.zhengjie.service.LxjcjyService;
import me.zhengjie.service.dto.JczlcxDeployQueryCriteria;
import me.zhengjie.service.dto.LxjcjyDeployQueryCriteria;
import me.zhengjie.util.shengneiUtil;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

//import static me.zhengjie.util.shengneiUtil.createSSLClientDefault;
//import static me.zhengjie.util.shengneiUtil.doPost;

/**
 * @author Jing Xiduo
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("api/LxjcjyController")
@Api(tags = "查询：连续缴存校验接口流水")
public class LxjcjyController {

    @Autowired
    private LxjcjyService lxjcjyService;

    @ApiOperation(value = "查询连续缴存校验接口流水")
    @GetMapping
    @PreAuthorize("@el.check('serverDeploy:list')")
    public ResponseEntity<Object> query(LxjcjyDeployQueryCriteria criteria, Pageable pageable){
        Object list = lxjcjyService.queryAll(criteria,pageable);
        return new ResponseEntity<>(list,HttpStatus.OK);
    }
}
