package me.zhengjie.serviceimpl;

import lombok.RequiredArgsConstructor;
import me.zhengjie.domain.LxjcjyDeploy;
import me.zhengjie.mapper.LxjcjyMapper;
import me.zhengjie.repository.LxjcjyDeployRepository;
import me.zhengjie.service.LxjcjyService;
import me.zhengjie.service.dto.LxjcjyDeployQueryCriteria;
import me.zhengjie.utils.PageUtil;
import me.zhengjie.utils.QueryHelp;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * @author Jing Xiduo
 * @date 2021-10-18
 */
@Service
@RequiredArgsConstructor
public class LxjcjyServiceImpl implements LxjcjyService {

    private final LxjcjyDeployRepository lxjcjyDeployRepository;
    private final LxjcjyMapper lxjcjyMapper;
    @Override
    public Object queryAll(LxjcjyDeployQueryCriteria criteria, Pageable pageable){
        Page<LxjcjyDeploy> page = lxjcjyDeployRepository.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,criteria,criteriaBuilder),pageable);
        return PageUtil.toPage(page.map(lxjcjyMapper::toDto));
    }
}
