package me.zhengjie.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.java.Log;
import me.zhengjie.annotation.AnonymousAccess;
import me.zhengjie.service.ICEGNService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * @author JiangHeJia
 * @version V1.0
 * @Title: gatewayZsjJlController
 * @Package el-admin
 * @Description: TODO(调用政务外网接口控制器)
 * @date 2021/10/11 10:53
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("api/CEGNController")
@Api(tags = "查询：调用政务外网接口")
@Log
public class CEGNController {


    @Autowired
    private ICEGNService ICEGNService;

    @ApiOperation("查询公司注册信息")
    @AnonymousAccess
    @RequestMapping("/queryEBaseinfosController")
    public String Test(Map map1) {
        return ICEGNService.queryEBaseinfos(map1);
    }
}
