/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package me.zhengjie.domain;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import me.zhengjie.base.BaseEntity;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Date;

/**
* @author Jing Xiduo
* @date 2021-10-18
*/
@Entity
@Getter
@Setter
@Table(name="SJGX_JKLSB")
public class QyxxcxDeploy extends BaseEntity implements Serializable {

    @Id
    @Column(name = "ID")
    @ApiModelProperty(value = "ID", hidden = true)
    @SequenceGenerator(name = "QyxxcxDeployGenerator" ,sequenceName = "SEQ_SJGX_JKLSB")
    @GeneratedValue(strategy = GenerationType.SEQUENCE,generator = "QyxxcxDeployGenerator")
    private Long id;


    @ApiModelProperty(value = "请求内容")
    private String qqnr;

    @ApiModelProperty(value = "请求时间")
    private Date qqsj;

    @ApiModelProperty(value = "响应内容")
    private String xynr;

    @ApiModelProperty(value = "响应时间")
    private Date xysj;

    @ApiModelProperty(value = "响应状态")
    private String xyzt;

    @ApiModelProperty(value = "请求接口")
    private String qqjk;

    @ApiModelProperty(value = "统一社会信用代码")
    private String uniscid;

    @ApiModelProperty(value = "名称(单位名称)")
    private String entName;

    @ApiModelProperty(value = "类型(单位类型)")
    private String entTypeCn;

    @ApiModelProperty(value = "法定代表人")
    private String name;

    @ApiModelProperty(value = "经营范围")
    private String opScope;

    @ApiModelProperty(value = "注册资本")
    private String regCap;

    @ApiModelProperty(value = "成立日期")
    private String estDate;

    @ApiModelProperty(value = "经营(驻在)期限自")
    private String opFrom;

    @ApiModelProperty(value = "经营(驻在)期限至")
    private String opto;

    @ApiModelProperty(value = "住所(单位地址)")
    private String dom;

    @ApiModelProperty(value = "登记机关")
    private String regOrgCn;

    @ApiModelProperty(value = "登记状态")
    private String regStateCn;


    public void copy(QyxxcxDeploy source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
