package me.zhengjie.serviceimpl;

import lombok.RequiredArgsConstructor;
import me.zhengjie.domain.JczlcxDeploy;
import me.zhengjie.domain.QyxxcxDeploy;
import me.zhengjie.mapper.JczlcxMapper;
import me.zhengjie.mapper.QyxxcxMapper;
import me.zhengjie.repository.JczlcxDeployRepository;
import me.zhengjie.repository.QyxxcxDeployRepository;
import me.zhengjie.service.JczlcxService;
import me.zhengjie.service.QyxxcxService;
import me.zhengjie.service.dto.JczlcxDeployQueryCriteria;
import me.zhengjie.service.dto.QyxxcxDeployQueryCriteria;
import me.zhengjie.utils.PageUtil;
import me.zhengjie.utils.QueryHelp;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * @author Jing Xiduo
 * @date 2021-10-18
 */
@Service
@RequiredArgsConstructor
public class JczlcxServiceImpl implements JczlcxService {

    private final JczlcxDeployRepository jczlcxDeployRepository;
    private final JczlcxMapper jczlcxMapper;
    @Override
    public Object queryAll(JczlcxDeployQueryCriteria criteria, Pageable pageable){
        Page<JczlcxDeploy> page = jczlcxDeployRepository.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,criteria,criteriaBuilder),pageable);
        return PageUtil.toPage(page.map(jczlcxMapper::toDto));
    }
}
