/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package me.zhengjie.modules.quartz.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import me.zhengjie.util.shengneiUtil;
import me.zhengjie.utils.RedisUtils;
import org.apache.http.NameValuePair;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 测试用
 * @author Zheng Jie
 * @date 2019-01-08
 */
@Slf4j
@Component
public class TestTask {

    @Autowired
    RedisUtils redisUtils;
    public void runToken(){
        CloseableHttpClient httpClinet = shengneiUtil.createSSLClientDefault();
        List<NameValuePair> nvps = new ArrayList<NameValuePair>();
        //client_id
        nvps.add(new BasicNameValuePair("client_id", "fc5ef720-7fbc-17b1-71f2-0dffcae9ab33"));
        //client_secret
        nvps.add(new BasicNameValuePair("client_secret", "0b525da488a54ad8bf27ac3d857ed407"));
        nvps.add(new BasicNameValuePair("grant_type", "client_credentials"));
        nvps.add(new BasicNameValuePair("scope", "token"));
        String jsonStr = shengneiUtil.httpPostCoder(httpClinet,"https://gateway.zsj.jl.cegn.cn/oauth2/token", nvps); //post请求
        JSONObject parseObject = JSON.parseObject(jsonStr);
        if (!"".equals(parseObject.getString("access_token"))){
            redisUtils.set("access_token",parseObject.getString("access_token"));
            log.info("获取token："+redisUtils.get("access_token"));
        }else{
            log.info("返回token为空");
        }
    }
}
