package me.zhengjie.serviceimpl;

import lombok.RequiredArgsConstructor;
import me.zhengjie.domain.QyxxcxDeploy;
import me.zhengjie.mapper.QyxxcxMapper;
import me.zhengjie.repository.QyxxcxDeployRepository;
import me.zhengjie.service.QyxxcxService;
import me.zhengjie.service.dto.QyxxcxDeployQueryCriteria;
import me.zhengjie.utils.PageUtil;
import me.zhengjie.utils.QueryHelp;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * @author JiangHeJia
 * @version V1.0
 * @Title: QyxxcxServiceImpl
 * @Package eladmin
 * @Description: TODO(查询企业信息接口流水实现类)
 * @date 2021/9/26 15:33
 */
@Service
@RequiredArgsConstructor
public class QyxxcxServiceImpl implements  QyxxcxService {

    private final QyxxcxDeployRepository qyxxcxDeployRepository;
    private final QyxxcxMapper qyxxcxMapper;
    @Override
    public Object queryAll(QyxxcxDeployQueryCriteria criteria, Pageable pageable){
        Page<QyxxcxDeploy> page = qyxxcxDeployRepository.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,criteria,criteriaBuilder),pageable);
        return PageUtil.toPage(page.map(qyxxcxMapper::toDto));
    }
}
