package me.zhengjie.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.java.Log;
import me.zhengjie.annotation.AnonymousAccess;
import me.zhengjie.service.ICEGNService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * @author JiangHeJia
 * @version V1.0
 * @Title: gatewayZsjJlController
 * @Package el-admin
 * @Description: 调用政务外网接口控制器
 * @date 2021/10/11 10:53
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("api/CEGNController")
@Api(tags = "查询：调用政务外网接口")
@Log
public class CEGNController {


    @Autowired
    private ICEGNService ICEGNService;

    @ApiOperation("企业登记基本信息查询")
    @AnonymousAccess
    @RequestMapping("/queryEBaseinfos")
    public String queryEBaseinfos(Map map1) {
        return ICEGNService.queryEBaseinfos(map1);
    }

    @ApiOperation("社会保险证明查询")
    @AnonymousAccess
    @RequestMapping("/getSocialSecurityCertificateDetail")
    public String getSocialSecurityCertificateDetail(Map map1) {
        return ICEGNService.getSocialSecurityCertificateDetail(map1);
    }

    @ApiOperation("公安厅居民身份证信息查询")
    @AnonymousAccess
    @RequestMapping("/gatlicresidentidcardlistquery")
    public String gatlicresidentidcardlistquery(Map map1) {
        return ICEGNService.gatlicresidentidcardlistquery(map1);
    }
}
