/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package me.zhengjie.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import me.zhengjie.service.DkzlcxService;
import me.zhengjie.service.LxjcjyService;
import me.zhengjie.service.dto.DkzlcxDeployQueryCriteria;
import me.zhengjie.service.dto.LxjcjyDeployQueryCriteria;
import me.zhengjie.util.R;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

//import static me.zhengjie.util.shengneiUtil.createSSLClientDefault;
//import static me.zhengjie.util.shengneiUtil.doPost;

/**
 * @author Jing Xiduo
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("api/DkzlcxController")
@Api(tags = "查询：贷款纵览查询接口流水")
public class DkzlcxController {

    @Autowired
    private DkzlcxService dkzlcxService;

    @ApiOperation(value = "查询贷款纵览查询接口流水")
    @GetMapping
    @PreAuthorize("@el.check('serverDeploy:list')")
    public ResponseEntity<Object> query(DkzlcxDeployQueryCriteria criteria, Pageable pageable){
        return new ResponseEntity<>(dkzlcxService.queryAll(criteria,pageable),HttpStatus.OK);
    }


    @ApiOperation("贷款纵览查询返回明细")
    @RequestMapping("/QueryDkzlcxFhmx")
    public R QueryDkzlcxFhmx(@RequestParam("id") String id) {
        List<Map> visits = dkzlcxService.QueryDkzlcxFhmx(id);
        return new R<>(visits);
    }

}
