/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package me.zhengjie.modules.system.domain;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import me.zhengjie.base.BaseEntity;
import me.zhengjie.utils.enums.DataScopeEnum;

import javax.persistence.*;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;

/**
 * 角色
 * @author Zheng Jie
 * @date 2018-11-22
 */
@Getter
@Setter
@Entity
@Table(name = "SJGX_SYS_ROLE")
public class Role extends BaseEntity implements Serializable {

    @Id
    @Column(name = "ROLE_ID")
    @NotNull(groups = {Update.class})
    @ApiModelProperty(value = "ID", hidden = true)
    @SequenceGenerator(name = "roleGenerator" ,sequenceName = "SEQ_SJGX_ROLE")
    @GeneratedValue(strategy = GenerationType.SEQUENCE,generator = "roleGenerator")
    private Long id;

    @JSONField(serialize = false)
    @ManyToMany(mappedBy = "roles")
    @ApiModelProperty(value = "用户", hidden = true)
    private Set<User> users;

    @ManyToMany
    @JoinTable(name = "SJGX_SYS_ROLES_MENUS",
            joinColumns = {@JoinColumn(name = "ROLE_ID",referencedColumnName = "ROLE_ID")},
            inverseJoinColumns = {@JoinColumn(name = "MENU_ID",referencedColumnName = "MENU_ID")})
    @ApiModelProperty(value = "菜单", hidden = true)
    private Set<Menu> menus;

    @ManyToMany
    @JoinTable(name = "SJGX_SYS_ROLES_DEPTS",
            joinColumns = {@JoinColumn(name = "ROLE_ID",referencedColumnName = "ROLE_ID")},
            inverseJoinColumns = {@JoinColumn(name = "DEPT_ID",referencedColumnName = "DEPT_ID")})
    @ApiModelProperty(value = "部门", hidden = true)
    private Set<Dept> depts;

    @NotBlank
    @ApiModelProperty(value = "名称", hidden = true)
    private String name;

    @ApiModelProperty(value = "数据权限，全部 、 本级 、 自定义")
    private String dataScope = DataScopeEnum.THIS_LEVEL.getValue();

    @Column(name = "role_level")
    @ApiModelProperty(value = "级别，数值越小，级别越大")
    private Integer level = 3;

    @ApiModelProperty(value = "描述")
    private String description;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Role role = (Role) o;
        return Objects.equals(id, role.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
