/*
 *  Copyright 2019-2020 Zheng Jie
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package me.zhengjie.domain;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import me.zhengjie.base.BaseEntity;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Date;

/**
* @author Jing Xiduo
* @date 2021-10-18
*/
@Entity
@Getter
@Setter
@Table(name="SJGX_BDC321_XXGXSQSQ")
public class XxgxsqsqDeploy extends BaseEntity implements Serializable {

    @Id
    @Column(name = "ID")
    @ApiModelProperty(value = "ID", hidden = true)
    @SequenceGenerator(name = "XxgxsqsqDeployGenerator" ,sequenceName = "SEQ_SJGX_BDC321_XXGXSQSQ",allocationSize = 1)
    @GeneratedValue(strategy = GenerationType.SEQUENCE,generator = "XxgxsqsqDeployGenerator")
    private Long id;
    @ApiModelProperty(value = "姓名")
    private String xingming;
    @ApiModelProperty(value = "证件类型")
    private String zjlx;
    @ApiModelProperty(value = "备用字段1")
    private String bk1;
    @ApiModelProperty(value = "备用字段2")
    private String bk2;
    @ApiModelProperty(value = "备用字段3")
    private String bk3;
    @ApiModelProperty(value = "备用字段4")
    private String bk4;
    @ApiModelProperty(value = "备用字段5")
    private String bk5;
    @ApiModelProperty(value = "处理状态")
    private String fileserverstat;
    @ApiModelProperty(value = "失败原因")
    private String errorreason;
    @ApiModelProperty(value = "返回报文：备用字段1")
    private String rbk1;
    @ApiModelProperty(value = "返回报文：备用字段2")
    private String rbk2;
    @ApiModelProperty(value = "0 待发送 1 已发送 2 已接受结果 ")
    private String status;
    @ApiModelProperty(value = "插入日期")
    private Date crrq;
    @ApiModelProperty(value = "返回日期")
    private Date fhrq;
    @ApiModelProperty(value = "报文头返回状态 0 成功 1失败 ")
    private String txstatus;
    @ApiModelProperty(value = "报文头返回解释")
    private String rtnmessage;
    @ApiModelProperty(value = "发送方日期")
    private String senddate;
    @ApiModelProperty(value = "发送方时间")
    private String sendtime;
    @ApiModelProperty(value = "发送方流水号")
    private String sendseqno;
    @ApiModelProperty(value = "交易机构号")
    private String txunitno;
    @ApiModelProperty(value = "发送方节点号")
    private String sendnode;
    @ApiModelProperty(value = "交易代码")
    private String txcode;
    @ApiModelProperty(value = "接收方节点号")
    private String receivenode;
    @ApiModelProperty(value = "客户编号")
    private String custno;
    @ApiModelProperty(value = "操作员编号")
    private String operno;
    @ApiModelProperty(value = "返回报文头日期")
    private String receivedate;
    @ApiModelProperty(value = "返回报文头时间")
    private String receivetime;
    @ApiModelProperty(value = "返回报文流水号")
    private String receiveseqno;
    @ApiModelProperty(value = "证件号码")
    private String zjhm;
    @ApiModelProperty(value = "中心编号")
    private String zxbh;
    @ApiModelProperty(value = "业务类型")
    private String ywlx;
    @ApiModelProperty(value = "业务子类型")
    private String ywzlx;
    @ApiModelProperty(value = "业务办理日期")
    private String ywblrq;
    @ApiModelProperty(value = "返回报文：授权记录ID")
    private String sq_id;
    @ApiModelProperty(value = "返回报文：申请结果(0-申请通过,1-申请失败) ")
    private String sqjg;
    @ApiModelProperty(value = "返回报文：备用字段3")
    private String rbk3;
    @ApiModelProperty(value = "返回报文：备用字段4")
    private String rbk4;
    @ApiModelProperty(value = "返回报文：备用字段5")
    private String rbk5;
    @ApiModelProperty(value = "")
    private String dkzhzt;
    @ApiModelProperty(value = "")
    private String recnum;

    public void copy(XxgxsqsqDeploy source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
