package com.me.flowable.modeler.rest;

import com.me.flowable.modeler.service.dto.ModelerQueryCriteria;
import com.me.flowable.modeler.service.vo.ProcessDefinitionVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import me.zhengjie.utils.PageUtil;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.runtime.ProcessInstanceBuilder;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Zheng Jie
 * @date 2019-03-25
 */
@RestController
@RequiredArgsConstructor
@Api(tags = "工作流：流程设计器")
@RequestMapping("/api/modeler")
public class ModelerController {

    @Autowired
    private ProcessEngine processEngine;

    @ApiOperation("部署流程查询")
    @GetMapping
    public ResponseEntity<Object> query(ModelerQueryCriteria criteria, Pageable pageable){
        List<ProcessDefinition> processDefinitionList = processEngine.getRepositoryService().createProcessDefinitionQuery().latestVersion().list();
        List<ProcessDefinitionVo> processDefinitionVoList =new ArrayList<>();
        processDefinitionList.stream().forEach(processDefinition -> {
            ProcessDefinitionVo processDefinitionVo = new ProcessDefinitionVo();
            BeanUtils.copyProperties(processDefinition , processDefinitionVo);
            processDefinitionVoList.add(processDefinitionVo);
        });
        return new ResponseEntity<>(PageUtil.toPage(processDefinitionVoList, processDefinitionVoList.size()),HttpStatus.OK);
    }


}
