package me.zhengjie.serviceimpl;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.java.Log;
import me.zhengjie.service.ICEGNService;
import me.zhengjie.util.shengneiUtil;
import me.zhengjie.utils.RedisUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @author JiangHeJia
 * @version V1.1
 * @Title: IGatewayZsjJIServiceImpl
 * @Package el-admin
 * @Description: 调用政务外网接口实现类
 * @date 2021年10月13日16:12:48
 */
@Service
@Log
public class CGENServiceImpl implements ICEGNService {

    @Autowired
    RedisUtils redisUtils;

    /**
     * @Title: queryEBaseinfos
     * @Description: 企业登记信息查询实现
     * * @param: Map
     * * @return: String
     * @date: 2021/10/11 13:56
     */
    @Override
    public String queryEBaseinfos(Map map1) {
        log.info("企业登记信息查询");
        Map map = (Map) map1.get("BODY");
        JSONObject obj = new JSONObject();
        obj.put("uniscid", map.get("TYSHXYDM"));
        obj.put("entName", map.get("DWMC"));
        String doPost = shengneiUtil.doPosts(obj);
        log.info("接口返回信息" + doPost);
        return doPost;
    }
    /**
     * @Title: getSocialSecurityCertificateDetail
     * @Description: 企业登记信息查询实现
     * * @param: Map
     * * @return: String
     * @date: 2021/10/11 13:56
     */
    @Override
    public String getSocialSecurityCertificateDetail(Map map1) {
        log.info("企业登记信息查询");
        Map map = (Map) map1.get("BODY");
        JSONObject obj = new JSONObject();
        obj.put("idCard", map.get("ZJHM"));
        obj.put("name", map.get("XINGMING"));
        String doPost = shengneiUtil.doPosts(obj);
        log.info("接口返回信息" + doPost);
        return doPost;
    }
    /**
     * @Title: gatlicresidentidcardlistquery
     * @Description: 公安厅居民身份证信息查询实现
     * * @param: Map
     * * @return: String
     * @date: 2021/10/11 13:56
     */
    @Override
    public String gatlicresidentidcardlistquery(Map map1) {
        log.info("公安厅居民身份证信息查询");
        Map map = (Map) map1.get("BODY");
        JSONObject obj = new JSONObject();
        obj.put("idcardNo", map.get("ZJHM"));
        obj.put("name", map.get("XINGMING"));
        String doPost = shengneiUtil.doPosts(obj);
        log.info("接口返回信息" + doPost);
        return doPost;
    }
}
